@extends('layouts.UserLayout')
@section('content')
@php
@endphp
<!-- Content wrapper -->
<div class="container-xxl flex-grow-1 container-p-y" xmlns="http://www.w3.org/1999/html">
  <div class="row">
    <div class="col-md-12">
      <div class="card mb-4 mt-5">
          <h5 class="card-header bg-info mb-4">DNS Name Server Details</h5>
        <div class="card-body">

              <div class="col-12 my-2 text-center">
                  <div title="This is ernet server" class="form-check form-check-inline">
                      <input class="form-check-input" type="radio" name="name_server_type" id="ernet_name_server_form" value="ernet_name_server_form"
                             checked >
                      <label class="form-check-label">ERNET Name Server</label>
                  </div>
                  <div title="This is user server" class="form-check form-check-inline">
                      <input class="form-check-input" type="radio" name="name_server_type" value="user_name_server_form"
                             @if($user_name_server != null)
                                @if($user_name_server->server_type == 2) checked @endif
                            @endif
                      >
                      <label class="form-check-label">Other Name Server</label>
                  </div>
              </div>
              <br>
            <div class="user-server-form">
                <form role="form" action="{{url('addDnsNameServerUser')}}"  method="post">
                    @csrf
                    <div class="row">

                        <div class="col-6 my-2 primary_server">
                            <label class="form-label">Primary Name Server <span style="color: red">*</span> </label>
                            <input type="text" class="form-control" id="primary_server" name="primary_name_server" placeholder="Primary Name Server" value="@if($user_name_server != null && $user_name_server->server_type == 2){{$user_name_server->primary_name_server}}@endif"  required/>
                        </div>
                        @if($user_name_server != null)
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->primary_name_server_ip != null)
                                @php
                                    $domain_fragmented = explode(".", $user_name_server->primary_name_server_ip);
                                @endphp
                                <div class="col-6 my-2 primary_server_ips">
                                    <label class="form-label">Primary Name Server IP<span style="color: red">*</span></label>
                                    <div class="input-group">
                                        @foreach($domain_fragmented as $key=>$value)
                                            <input type="number" class="form-control ip_input" name="primary_name_server_ip[]"  placeholder="127" value="{{$value}}"  />
                                            @if($key ==3)
                                                @break;
                                            @endif
                                            <span class="input-group-text" id="basic-addon11">.</span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                                @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->primary_name_server_ip6 != null)
                                    @php
                                        $domain_fragmented = explode(":", $user_name_server->primary_name_server_ip6);
                                    @endphp
                                    <div class="col-12 my-2 primary_server_ips">
                                        <label class="form-label">Primary Name Server IPV6<span style="color: red">*</span></label>
                                        <div class="input-group">
                                            @foreach($domain_fragmented as $key=>$value)
                                                <input type="text" class="form-control ip_input6" name="primary_name_server_ip6[]"  placeholder="2001" value="{{$value}}"  />
                                                @if($key ==5)
                                                    @break;
                                                @endif
                                                <span class="input-group-text" id="basic-addon11">:</span>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif
                        @endif


                        <div class="col-6 my-2 primary_server_one">
                            <label class="form-label">Secondary Name Server 1<span style="color: red">*</span></label>
                            <input type="text" class="form-control " id="primary_server_one"  name="secondary_name_server1" placeholder="Secondary Name Server 1" value="@if($user_name_server != null && $user_name_server->server_type == 2 ){{$user_name_server->primary_name_server}} @endif" required />
                        </div>

                        @if($user_name_server != null)
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->secondary_name_server1_ip != null)
                                @php
                                    $domain_fragmented = explode(".", $user_name_server->secondary_name_server1_ip);
                                @endphp
                                <div class="col-6 my-2 primary_server_ips">
                                    <label class="form-label">Secondary Name Server 1 IP<span style="color: red">*</span></label>
                                    <div class="input-group">
                                        @foreach($domain_fragmented as $key=>$value)
                                            <input type="number" class="form-control ip_input" name="primary_name_server_ip[]"  placeholder="127" value="{{$value}}"  />
                                            @if($key ==3)
                                                @break;
                                            @endif
                                            <span class="input-group-text" id="basic-addon11">.</span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->secondary_name_server1_ip6 != null)
                                @php
                                    $domain_fragmented = explode(":", $user_name_server->secondary_name_server1_ip6);
                                @endphp
                                <div class="col-12 my-2 primary_server_ips">
                                    <label class="form-label">Secondary Name Server IPV6<span style="color: red">*</span></label>
                                    <div class="input-group">
                                        @foreach($domain_fragmented as $key=>$value)
                                            <input type="text" class="form-control ip_input6" name="primary_name_server_ip6[]"  placeholder="2001" value="{{$value}}"  />
                                            @if($key ==5)
                                                @break;
                                            @endif
                                            <span class="input-group-text" id="basic-addon11">:</span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        @endif


                        <div class="col-6 my-2 primary_server_two ">
                            <label class="form-label">Secondary Name Server 2</label>
                            <input type="text" class="form-control" id="primary_server_two" name="secondary_name_server2" placeholder="Secondary Name Server 2" value="@if($user_name_server != null && $user_name_server->server_type == 2){{$user_name_server->secondary_name_server2}} @endif"/>
                        </div>
                        @if($user_name_server != null)
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->secondary_name_server2_ip != null)
                                @php
                                    $domain_fragmented = explode(".", $user_name_server->secondary_name_server2_ip);
                                @endphp
                                <div class="col-6 my-2 primary_server_ips">
                                    <label class="form-label">Secondary Name Server 2 IP<span style="color: red">*</span></label>
                                    <div class="input-group">
                                        @foreach($domain_fragmented as $key=>$value)
                                            <input type="number" class="form-control ip_input" name="primary_name_server_ip[]"  placeholder="127" value="{{$value}}"  />
                                            @if($key ==3)
                                                @break;
                                            @endif
                                            <span class="input-group-text" id="basic-addon11">.</span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->secondary_name_server2_ip6 != null)
                                @php
                                    $domain_fragmented = explode(":", $user_name_server->secondary_name_server2_ip6);
                                @endphp
                                <div class="col-12 my-2 primary_server_ips">
                                    <label class="form-label">Primary Name Server IPV6<span style="color: red">*</span></label>
                                    <div class="input-group">
                                        @foreach($domain_fragmented as $key=>$value)
                                            <input type="text" class="form-control ip_input6" name="primary_name_server_ip6[]"  placeholder="2001" value="{{$value}}"  />
                                            @if($key ==5)
                                                @break;
                                            @endif
                                            <span class="input-group-text" id="basic-addon11">:</span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        @endif

                        <div class="col-6 my-2 primary_server_three">
                            <label class="form-label">Secondary Name Server 3</label>
                            <input type="text" class="form-control" id="primary_server_three" name="secondary_name_server3" placeholder="Secondary Name Server 3" value="@if($user_name_server != null && $user_name_server->server_type == 2){{$user_name_server->secondary_name_server3}} @endif"/>
                        </div>
                        @if($user_name_server != null)
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->secondary_name_server3_ip != null)
                            @php
                                $domain_fragmented = explode(".", $user_name_server->secondary_name_server3_ip);
                            @endphp
                            <div class="col-6 my-2 primary_server_ips">
                                <label class="form-label">Secondary Name Server 3 IP<span style="color: red">*</span></label>
                                <div class="input-group">
                                    @foreach($domain_fragmented as $key=>$value)
                                        <input type="number" class="form-control ip_input" name="primary_name_server_ip[]"  placeholder="127" value="{{$value}}"  />
                                        @if($key ==3)
                                            @break;
                                        @endif
                                        <span class="input-group-text" id="basic-addon11">.</span>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->secondary_name_server3_ip6 != null)
                            @php
                                $domain_fragmented = explode(":", $user_name_server->secondary_name_server3_ip6);
                            @endphp
                            <div class="col-12 my-2 primary_server_ips">
                                <label class="form-label">Primary Name Server IPV6<span style="color: red">*</span></label>
                                <div class="input-group">
                                    @foreach($domain_fragmented as $key=>$value)
                                        <input type="text" class="form-control ip_input6" name="primary_name_server_ip6[]"  placeholder="2001" value="{{$value}}"  />
                                        @if($key ==5)
                                            @break;
                                        @endif
                                        <span class="input-group-text" id="basic-addon11">:</span>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                        @endif

                        <div class="col-6 my-2 primary_server_four">
                            <label class="form-label">Secondary Name Server 4</label>
                            <input type="text" class="form-control" id="primary_server_four" name="secondary_name_server4" placeholder="Secondary Name Server 4" value="@if($user_name_server != null && $user_name_server->server_type == 2){{$user_name_server->secondary_name_server4}} @endif"/>
                        </div>
                        @if($user_name_server != null)
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->secondary_name_server4_ip != null)
                            @php
                                $domain_fragmented = explode(".", $user_name_server->secondary_name_server4_ip);
                            @endphp
                            <div class="col-6 my-2 primary_server_ips">
                                <label class="form-label">Secondary Name Server 4 IP<span style="color: red">*</span></label>
                                <div class="input-group">
                                    @foreach($domain_fragmented as $key=>$value)
                                        <input type="number" class="form-control ip_input" name="primary_name_server_ip[]"  placeholder="127" value="{{$value}}"  />
                                        @if($key ==3)
                                            @break;
                                        @endif
                                        <span class="input-group-text" id="basic-addon11">.</span>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->secondary_name_server4_ip6 != null)
                            @php
                                $domain_fragmented = explode(":", $user_name_server->secondary_name_server4_ip6);
                            @endphp
                            <div class="col-12 my-2 primary_server_ips">
                                <label class="form-label">Primary Name Server IPV6<span style="color: red">*</span></label>
                                <div class="input-group">
                                    @foreach($domain_fragmented as $key=>$value)
                                        <input type="text" class="form-control ip_input6" name="primary_name_server_ip6[]"  placeholder="2001" value="{{$value}}"  />
                                        @if($key ==5)
                                            @break;
                                        @endif
                                        <span class="input-group-text" id="basic-addon11">:</span>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                        @endif

                        <div class="col-6 my-2 primary_server_five">
                            <label class="form-label">Secondary Name Server 5</label>
                            <input type="text" class="form-control" id="primary_server_five" name="secondary_name_server5" placeholder="Secondary Name Server 5" value="@if($user_name_server != null && $user_name_server->server_type == 2){{$user_name_server->secondary_name_server5}} @endif" />
                        </div>
                        @if($user_name_server != null)
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->secondary_name_server5_ip != null)
                            @php
                                $domain_fragmented = explode(".", $user_name_server->secondary_name_server5_ip);
                            @endphp
                            <div class="col-6 my-2 primary_server_ips">
                                <label class="form-label">Secondary Name Server 5 IP<span style="color: red">*</span></label>
                                <div class="input-group">
                                    @foreach($domain_fragmented as $key=>$value)
                                        <input type="number" class="form-control ip_input" name="primary_name_server_ip[]"  placeholder="127" value="{{$value}}"  />
                                        @if($key ==3)
                                            @break;
                                        @endif
                                        <span class="input-group-text" id="basic-addon11">.</span>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                            @if($user_name_server != null && $user_name_server->server_type == 2 && $user_name_server->secondary_name_server5_ip6 != null)
                            @php
                                $domain_fragmented = explode(":", $user_name_server->secondary_name_server5_ip6);
                            @endphp
                            <div class="col-12 my-2 primary_server_ips">
                                <label class="form-label">Primary Name Server IPV6<span style="color: red">*</span></label>
                                <div class="input-group">
                                    @foreach($domain_fragmented as $key=>$value)
                                        <input type="text" class="form-control ip_input6" name="primary_name_server_ip6[]"  placeholder="2001" value="{{$value}}"  />
                                        @if($key ==5)
                                            @break;
                                        @endif
                                        <span class="input-group-text" id="basic-addon11">:</span>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                        @endif

                    </div>
                    <h5 class="text-info mt-3">Note : Name Server cannot be same as Domain Name</h5>
                    <div class="card-header m-auto p-0 my-2">
                        <div class="col-12 my-2">
                            <div class="form-check form-check-inline p-0">
                                <label class="form-check-label">Enable DNSSEC</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" id="enable_dnsse_no" name="enable_dnsse" value="no" checked>
                                <label class="form-check-label">No</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" id="enable_dnsse_yes" name="enable_dnsse" value="yes">
                                <label class="form-check-label">Yes</label>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 my-3" id="kripa">
                        <div class="table-responsive text-nowrap">
                            <table class="table table-bordered">
                                <thead>
                                <tr>
                                    <th>Key Tag</th>
                                    <th>Algorithm</th>
                                    <th>Digest Type</th>
                                    <th>Digest</th>
                                </tr>
                                </thead>
                                <tbody>

                                <tr>
                                    <td><input type="text" class="form-control" name="dnsse[0][key_tag]" id="key_tag" value=""></td>
                                    <td><input type="text" class="form-control" name="dnsse[0][algorithm]" id="algorithm" value=""></td>
                                    <td>
                                        <select name="dnsse[0][digest_type]" class="form-control">
                                            <option value="SHA1">SHA1</option>
                                        </select>
                                    </td>
                                    <td><input type="text" class="form-control" name="dnsse[0][digest]" id="digest" value=""></td>
                                </tr>

                                </tbody>
                            </table>
                        </div>
                        <div class="mb-4 mt-3 float-end">
                            <button type="button" class="btn btn-sm btn-danger remove-row">Remove</button>
                            <button type="button" id="add" value="Add" class="btn btn-sm btn-primary add-row">Add</button>
                        </div>
                    </div>
                    <div class="col-6 my-5">
                        <a href="{{url()->previous()}}"> <input type="button" class="btn btn-danger ml-3" id="back" name="back" value="Back"/></a>
                        <button class="btn btn-success mr-4" id="add-server-smt-btn" name="action" value="Submit">Submit</button>
                        <a href="{{ url('domain-payment')}}" class="btn btn-info mr-4" id="add-server-smt-btn"  >Skip</a>
                    </div>
                </form>
            </div>
            <div class="ernet-server-form d-none">
                <form action="{{url('addDnsNameServerErnet')}}"  method="post">
                    @csrf
                      <div class="row">
                          <div class="col-12 my-2">
                              <label class="form-label">Domain Name <span style="color: red">*</span> </label>
                              <input type="text" class="form-control" id="domain_name" name="domain_name" placeholder="" value="{{\Illuminate\Support\Facades\Auth::user()->domainName}}" disabled />
                          </div>
                          <div class="col-12 my-2">
                              <label class="form-label">DNS Service Duration</label>
                              <select class="form-control"  id="service_duration" name="dns_service_duration" required>
                                  @if($ernet_name_server_prices)
                                      <option value="">Select Duration</option>
                                      @foreach($ernet_name_server_prices as $price)
                                          <option value="{{$price->id}}" @if($user_name_server->ernet_name_server_duration_year ?? '0' == $price->id) selected @endif>{{$price->years}} years</option>
                                      @endforeach
                                      @endif
                              </select>
                          </div>
                          <div class="col-6 my-2">
                              <label class="form-label">Price</label>
                              <input type="text" class="form-control" name="server_price" id="server_price"  value="" readonly/>
                          </div>
                          <div class="col-6 my-2">
                              <label class="form-label"> Taxes ( 18.00 % )</label>
                              <input type="text" class="form-control" name="server_price_tax" id="server_price_tax"  value="" readonly/>
                          </div>
                          <div class="col-6 my-2">
                              <label class="form-label">Total Amount</label>
                              <input type="text" class="form-control" name="server_price_total" id="server_price_total" value="" readonly/>
                          </div>
                          <div class="col-12 my-2">
                              <label class="form-label">Primary Name Server </label>
                              <input type="text" class="form-control" id="primary_name_server" name="primary_name_server_ernet"  value="{{$ernet_name_server->primary_name_server??''}}" readonly/>
                          </div>
                          @foreach(json_decode($ernet_name_server->secondary_name_server) as $key=>$value)
                              <div class="col-6 my-2">
                                  <label class="form-label">Secondary Name Server {{$key+1}} </label>
                                  <input type="text" class="form-control secondaryNameServer{{$key+1}}" id="primary_server_five" name="secondary_name_server_ernet{{$key+1}}"  value="{{$value??''}}" readonly/>
                              </div>
                          @endforeach

                                        <input type="hidden" class="form-control" name="customer_name" id="customer_name"  value="{{Auth::user()->name}}" readonly/>
                                      <input type="hidden" class="form-control" name="amount" id="amount"  value="" readonly/>
                                      <input type="hidden" class="form-control" name="customer_email" id="customer_email"  value="{{Auth::user()->email}}" readonly/>
                                      <input type="hidden" class="form-control" name="transaction_type" id="transaction_type"  value="ernetNameServer" readonly/>
                                      <input type="hidden" class="form-control" name="remark" id="remark"  value="" readonly/>

                      </div>
                    <div class="col-6 my-5">
                        <a href="{{url()->previous()}}"> <input type="button" class="btn btn-danger ml-3" id="back" name="back" value="Back"/></a>
                        <button class="btn btn-success mr-4" type="submit" id="add-server-smt-btn" name="action" value="Submit">Submit</button>
                        <a href="{{ url('domain-payment')}}" class="btn btn-info mr-4" id="add-server-smt-btn"  >Skip</a>
                    </div>
                </form>
              </div>

        </div>
      </div>
    </div>
  </div>
</div>
<!-- Content wrapper -->

@endsection
@section("js")
<script>
    $( document ).ready(function() {
        if ($('#service_duration').val()){
            $.ajax({
                url: "{{ url('getNameServerPrice') }}"+'/'+$('#service_duration').val(),
                dataType : "json",
                type: "get",
                success : function(response) {
                    if(response.status == true) {
                        $('#server_price').val(response.data.price);
                        var server_price_gst_percent = (18*response.data.price)/100;
                        $('#server_price_tax').val(server_price_gst_percent);
                        $('#server_price_total').val(parseFloat(response.data.price)+parseFloat(server_price_gst_percent));
                    } else if(response.status == false) {
                        alert(response.message);
                    }
                },
            });
        }
    });

    var i = 0;
    $('.remove-row').hide();
    $(document).on("click",'.add-row',function(){
        $('.remove-row').show();
        i++;
        var markup = ' <tr id="row-'+i+'">'+
            '<td><input type="text" class="form-control" name="dnsse['+i+'][key_tag]" id="key_tag" value=""></td>'+
            ' <td><input type="text" class="form-control" name="dnsse['+i+'][algorithm]" id="algorithm" value=""></td>'+
            '<td> <select name="dnsse['+i+'][digest_type]" class="form-control">\n' +
            '                            <option value="SHA1">SHA1</option>\n' +
            '                        </select></td>'+
            '<td><input type="text" class="form-control" name="dnsse['+i+'][digest]" id="digest" value=""></td>'+
            '</tr>';
        $("table tbody").append(markup);
    });
    $(document).on("click",'.remove-row',function(){
        $('#row-'+i+'').remove();
        i--;
    });

  $("#enable_dnsse_no").click(function(){
    $("#kripa").hide();
  });

  $("#enable_dnsse_yes").click(function(){
     $("#kripa").show();
  });

    $(document).ready(function() {
        if ($("#ernet_name_server_form").prop("checked")) {
            $('.user-server-form').addClass('d-none');
            $('.ernet-server-form').removeClass('d-none');
        }else {
            $('.user-server-form').removeClass('d-none');
            $('.ernet-server-form').addClass('d-none');
        }

        $('input[type="radio"]').click(function() {
            if($(this).attr('id') == 'ernet_name_server_form') {
                $('.user-server-form').addClass('d-none');
                $('.ernet-server-form').removeClass('d-none');
            }

            else {
                $('.user-server-form').removeClass('d-none');
                $('.ernet-server-form').addClass('d-none');
            }
        });
    });

  $('#modified_ernet_server_form').validate({
    submitHandler:function(form)
    {
      $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url:"{{url('addDnsNameServerErnet')}}",
        type:'POST',
        dataType:'json',
        data:$("#modified_ernet_server_form").serialize(),
        cache: false,
        beforeSend: function(){
            $(".loader-area").show();
        },
        success:function(res)
        {
          if(res.status == true)
          {
              Swal.fire({
                  icon: 'success',
                  text: 'Name Server Details have been submitted successfully.',
                  showConfirmButton: true,
              }).then(function () {
                  window.location.href = "{{ url('dns-name-server-payment')}}";
              });
          }else if(res.status == false)
          {
              Swal.fire({
                  icon: 'error',
                  text: res.msg,
                  showConfirmButton: true,
              })
          }
        },
        complete: function(){
            $("#add-server-smt-btn").prop('disabled',false);
        },
      });
    }
  });

    $('#modified_user_server_form').validate({
        rules: {
            primary_server: {
                required: true,
            },
        },
        messages: {
            primary_server: {
                required: "Please fill server name",
                primary_server: "Please fill valid server name",
            },
        },

        submitHandler:function(form)
        {
            if ($('#primary_server').val() == $('#primary_name_server').val() || $('#primary_server').val() == $('.secondaryNameServer1').val() || $('#primary_server').val() == $('.secondaryNameServer2').val() || $('#primary_server').val() == $('.secondaryNameServer3').val()|| $('#primary_server').val() == $('.secondaryNameServer4').val()|| $('#primary_server').val() == $('.secondaryNameServer5').val()) {
                Swal.fire({
                    icon: 'error',
                    text: 'For "Other Name Server" Ernet name server cannot be used !',
                    showConfirmButton: true,
                });
                return false;
            }

            if ($('#primary_server_one').val() == $('#primary_name_server').val() || $('#primary_server_one').val() == $('.secondaryNameServer1').val() || $('#primary_server_one').val() == $('.secondaryNameServer2').val() || $('#primary_server_one').val() == $('.secondaryNameServer3').val()|| $('#primary_server_one').val() == $('.secondaryNameServer4').val()|| $('#primary_server_one').val() == $('.secondaryNameServer5').val()) {
                Swal.fire({
                    icon: 'error',
                    text: 'For "Other Name Server" Ernet name server cannot be used!',
                    showConfirmButton: true,
                });
                return false;
            }

            if ($('#primary_server_two').val() == $('#primary_name_server').val() || $('#primary_server_two').val() == $('.secondaryNameServer1').val() || $('#primary_server_two').val() == $('.secondaryNameServer2').val() || $('#primary_server_two').val() == $('.secondaryNameServer3').val()) {
                Swal.fire({
                    icon: 'error',
                    text: 'For "Other Name Server" Ernet name server cannot be used!',
                    showConfirmButton: true,
                });
                return false;
            }


            if ($('#primary_server_three').val() == $('#primary_name_server').val() || $('#primary_server_three').val() == $('.secondaryNameServer1').val() || $('#primary_server_three').val() == $('.secondaryNameServer2').val() || $('#primary_server_three').val() == $('.secondaryNameServer3').val() || $('#primary_server_three').val() == $('.secondaryNameServer4').val() || $('#primary_server_three').val() == $('.secondaryNameServer5').val()) {
                Swal.fire({
                    icon: 'error',
                    text: 'For "Other Name Server" Ernet name server cannot be used!',
                    showConfirmButton: true,
                });
                return false;
            }
            if ($('#primary_server_four').val() == $('#primary_name_server').val() || $('#primary_server_four').val() == $('.secondaryNameServer1').val() || $('#primary_server_four').val() == $('.secondaryNameServer2').val() || $('#primary_server_four').val() == $('.secondaryNameServer3').val()|| $('#primary_server_four').val() == $('.secondaryNameServer4').val() || $('#primary_server_four').val() == $('.secondaryNameServer5').val()) {
                Swal.fire({
                    icon: 'error',
                    text: 'For "Other Name Server" Ernet name server cannot be used!',
                    showConfirmButton: true,
                });
                return false;
            }
            if ($('#primary_server_five').val() == $('#primary_name_server').val() || $('#primary_server_five').val() == $('.secondaryNameServer1').val() || $('#primary_server_five').val() == $('.secondaryNameServer2').val() || $('#primary_server_five').val() == $('.secondaryNameServer3').val() || $('#primary_server_five').val() == $('.secondaryNameServer4').val() || $('#primary_server_five').val() == $('.secondaryNameServer5').val()) {
                Swal.fire({
                    icon: 'error',
                    text: 'For "Other Name Server" Ernet name server cannot be used!',
                    showConfirmButton: true,
                });
                return false;
            }


            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });


            $.ajax({
                url:"{{url('addDnsNameServerUser')}}",
                type:'POST',
                dataType:'json',
                data:$("#modified_user_server_form").serialize(),
                cache: false,
                beforeSend: function(){
                    $(".loader-area").show();
                },
                success:function(res)
                {
                    if(res.status == true)
                    {
                        Swal.fire({
                            icon: 'success',
                            text: 'Name Server Details have been submitted successfully.',
                            showConfirmButton: true,
                        }).then(function () {
                            window.location.href = "{{ url('domain-payment')}}";
                        });
                    }else if(res.status == false)
                    {
                        Swal.fire({
                            icon: 'error',
                            text: res.msg,
                            showConfirmButton: true,
                        })
                    }
                },
                complete: function(){
                    $("#add-server-smt-btn").prop('disabled',false);
                },
            });
        }
    });

    $(document).on("change",'#service_duration',function(){
        $.ajax({
            url: "{{ url('getNameServerPrice') }}"+'/'+$(this).val(),
            dataType : "json",
            type: "get",
            success : function(response) {

                if(response.status == true) {
                    $('#server_price').val(response.data.price);
                    var server_price_gst_percent = (18*response.data.price)/100;
                    $('#server_price_tax').val(server_price_gst_percent);
                    $('#server_price_total').val(parseFloat(response.data.price)+parseFloat(server_price_gst_percent));
                    $('#amount').val(parseFloat(response.data.price)+parseFloat(server_price_gst_percent));
                } else if(response.status == false) {
                    alert(response.message);
                }

            },
        });
    });

    $('#primary_server').unbind('keyup');
    $('#primary_server').bind('keyup',function(e) {
        if ($(this).val().length>8) {
            var domain = $(this).val();
            $('.primary_server_ips').remove();
            $.ajax({
                url: "{{ url('checkDNSMatch') }}",
                dataType : "json",
                data : {domain:domain},
                type: "get",
                success : function(response) {
                    $('.primary_server_ips').remove();
                    if(response == true) {
                        $(".primary_server").after('' +
                            '<div class="col-6 my-2 primary_server_ips">\n' +
                            '                            <label class="form-label">Primary Name Server IPv4<span style="color: red">*</span></label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="number" class="form-control ip_input" name="primary_name_server_ip[]"  placeholder="127" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="primary_name_server_ip[]" placeholder="254" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="primary_name_server_ip[]" placeholder="11" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="primary_name_server_ip[]" placeholder="2" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>'+
                            '<div class="col-12 my-2 primary_server_ips">\n' +
                            '                            <label class="form-label">Primary Name Server IPv6<span style="color: red"></span></label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="text" class="form-control ip_input6" name="primary_name_server_ip6[]"  placeholder="2001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="primary_name_server_ip6[]" placeholder="0db8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="primary_name_server_ip6[]" placeholder="0001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="primary_name_server_ip6[]" placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text" class="form-control ip_input6" name="primary_name_server_ip6[]"  placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="primary_name_server_ip6[]" placeholder="0ab9" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="primary_name_server_ip6[]" placeholder="C0A8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="primary_name_server_ip6[]" placeholder="0102" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>');
                    } else {

                    }
                },
            });
        }
    });

    $('#primary_server_one').unbind('keyup');
    $('#primary_server_one').bind('keyup',function(e) {
        if ($(this).val().length>8) {
            var domain = $(this).val();
            $('.primary_server_one_ips').remove();
            $.ajax({
                url: "{{ url('checkDNSMatch') }}",
                dataType : "json",
                data : {domain:domain},
                type: "get",
                success : function(response) {
                    $('.primary_server_one_ips').remove();
                    if(response == true) {
                        $(".primary_server_one").after('' +
                            '<div class="col-6 my-2 primary_server_one_ips ">\n' +
                            '                            <label class="form-label">Secondary Name Server 1 IPv4<span style="color: red">*</span></label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="number" class="form-control ip_input" name="secondary_name_server1_ip[]"  placeholder="127" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server1_ip[]" placeholder="268" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server1_ip[]" placeholder="11" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server1_ip[]" placeholder="2" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>'+
                            '<div class="col-12 my-2 primary_server_one_ips">\n' +
                            '                            <label class="form-label">Secondary Name Server 1 IPv6<span style="color: red"></span></label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="text" class="form-control ip_input6" name="secondary_name_server1_ip6[]"  placeholder="2001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server1_ip6[]" placeholder="0db8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server1_ip6[]" placeholder="0001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server1_ip6[]" placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text" class="form-control ip_input6" name="secondary_name_server1_ip6[]"  placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server1_ip6[]" placeholder="0ab9" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server1_ip6[]" placeholder="C0A8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server1_ip6[]" placeholder="0102" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>'
                        );
                    } else {

                    }
                },
            });
        }
    });
    $('#primary_server_two').unbind('keyup');
    $('#primary_server_two').bind('keyup',function(e) {
        if ($(this).val().length>8) {
            var domain = $(this).val();
            $('.primary_server_two_ips').remove();
            $.ajax({
                url: "{{ url('checkDNSMatch') }}",
                dataType : "json",
                data : {domain:domain},
                type: "get",
                success : function(response) {
                    $('.primary_server_two_ips').remove();
                    if(response == true) {
                        $(".primary_server_two").after('' +
                            '<div class="col-6 my-2 primary_server_two_ips">\n' +
                            '                            <label class="form-label">Secondary Name Server 2 IP<span style="color: red">*</span></label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server2_ip[]"  placeholder="127" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server2_ip[]" placeholder="268" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server2_ip[]" placeholder="11" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server2_ip[]" placeholder="2" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>'+
                            '<div class="col-12 my-2 primary_server_two_ips">\n' +
                            '                            <label class="form-label">Secondary Name Server 2 IPv6<span style="color: red"></span></label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="text" class="form-control ip_input6" name="secondary_name_server2_ip6[]"  placeholder="2001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server2_ip6[]" placeholder="0db8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server2_ip6[]" placeholder="0001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server2_ip6[]" placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text" class="form-control ip_input6" name="secondary_name_server2_ip6[]"  placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server2_ip6[]" placeholder="0ab9" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server2_ip6[]" placeholder="C0A8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server2_ip6[]" placeholder="0102" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>');
                    } else {

                    }
                },
            });
        }
    });
    $('#primary_server_three').unbind('keyup');
    $('#primary_server_three').bind('keyup',function(e) {
        if ($(this).val().length>8) {
            var domain = $(this).val();
            $('.primary_server_three_ips').remove();
            $.ajax({
                url: "{{ url('checkDNSMatch') }}",
                dataType : "json",
                data : {domain:domain},
                type: "get",
                success : function(response) {
                    $('.primary_server_three_ips').remove();
                    if(response == true) {
                        $(".primary_server_three").after('' +
                            '<div class="col-6 my-2 primary_server_three_ips">\n' +
                            '                            <label class="form-label">Secondary Name Server 3 IPv4<span style="color: red">*</span></label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server3_ip[]"  placeholder="127" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server3_ip[]" placeholder="268" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server3_ip[]" placeholder="11" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server3_ip[]" placeholder="2" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>'+
                            '<div class="col-12 my-2 primary_server_three_ips">\n' +
                            '                            <label class="form-label">Secondary Name Server 3 IPv6<span style="color: red"></span></label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="text" class="form-control ip_input6" name="secondary_name_server3_ip6[]"  placeholder="2001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server3_ip6[]" placeholder="0db8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server3_ip6[]" placeholder="0001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server3_ip6[]" placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text" class="form-control ip_input6" name="secondary_name_server3_ip6[]"  placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server3_ip6[]" placeholder="0ab9" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server3_ip6[]" placeholder="C0A8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server3_ip6[]" placeholder="0102" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>');
                    } else {

                    }
                },
            });
        }
    });
    $('#primary_server_four').unbind('keyup');
    $('#primary_server_four').bind('keyup',function(e) {
        if ($(this).val().length>8) {
            var domain = $(this).val();
            $('.primary_server_four_ips').remove();
            $.ajax({
                url: "{{ url('checkDNSMatch') }}",
                dataType : "json",
                data : {domain:domain},
                type: "get",
                success : function(response) {
                    $('.primary_server_four_ips').remove();
                    if(response == true) {
                        $(".primary_server_four").after('' +
                            '<div class="col-6 my-2 primary_server_four_ips">\n' +
                            '                            <label class="form-label">Secondary Name Server 4 IPv4</label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server4_ip[]"  placeholder="127" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server4_ip[]" placeholder="268" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server4_ip[]" placeholder="11" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server4_ip[]" placeholder="2" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>'+
                            '<div class="col-12 my-2 primary_server_four_ips">\n' +
                            '                            <label class="form-label">Secondary Name Server 4 IPv6<span style="color: red"></span></label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="text" class="form-control ip_input6" name="secondary_name_server4_ip6[]"  placeholder="2001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server4_ip6[]" placeholder="0db8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server4_ip6[]" placeholder="0001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server4_ip6[]" placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text" class="form-control ip_input6" name="secondary_name_server4_ip6[]"  placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server4_ip6[]" placeholder="0ab9" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server4_ip6[]" placeholder="C0A8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server4_ip6[]" placeholder="0102" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>');
                    } else {

                    }
                },
            });
        }
    });
    $('#primary_server_five').unbind('keyup');
    $('#primary_server_five').bind('keyup',function(e) {
        if ($(this).val().length>8) {
            var domain = $(this).val();
            $('.primary_server_five_ips').remove();
            $.ajax({
                url: "{{ url('checkDNSMatch') }}",
                dataType : "json",
                data : {domain:domain},
                type: "get",
                success : function(response) {
                    $('.primary_server_five_ips').remove();
                    if(response == true) {
                        $(".primary_server_five").after('' +
                            '<div class="col-6 my-2 primary_server_five_ips">\n' +
                            '                            <label class="form-label">Secondary Name Server 5 IPv4</label>\n' +
                            '                        <div class="input-group">\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server5_ip[]"  placeholder="127" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server5_ip[]" placeholder="268" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server5_ip[]" placeholder="11" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">.</span>\n' +
                            '                            <input type="number"  class="form-control ip_input" name="secondary_name_server5_ip[]" placeholder="2" value="" ' +
                            ' />\n' +
                            '                        </div>\n' +
                            '                    </div>'+
                            '<div class="col-12 my-2 primary_server_five_ips">\n' +
                            '                            <label class="form-label">Secondary Name Server 5 IPv6<span style="color: red"></span></label>\n' +
                            '                            <div class="input-group">\n' +
                            '                            <input type="text" class="form-control ip_input6" name="secondary_name_server5_ip6[]"  placeholder="2001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server5_ip6[]" placeholder="0db8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server5_ip6[]" placeholder="0001" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server5_ip6[]" placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text" class="form-control ip_input6" name="secondary_name_server5_ip6[]"  placeholder="0000" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server5_ip6[]" placeholder="0ab9" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server5_ip6[]" placeholder="C0A8" value=""  />\n' +
                            '                            <span class="input-group-text" id="basic-addon11">:</span>\n' +
                            '                            <input type="text"  class="form-control ip_input6" name="secondary_name_server5_ip6[]" placeholder="0102" value=""  />\n' +
                            '                        </div>\n' +
                            '                    </div>');
                    } else {

                    }
                },
            });
        }
    });

    $('body').on("keypress", '.ip_input', function(e) {

        if ($(this).val().length > 2) {

            if($(this).val()>255){
                alert('Only less than 255  is allowed');
            }
            e.preventDefault();
        }

    });

    $('body').on("keypress", '.ip_input6', function(e) {
        if ($(this).val().length > 3) {
            e.preventDefault();
        }

        // var txt = $(this).val();
        // if (!txt.match(/[0-9a-fA-F]/)) {
        //     alert('only hexadecimal allowed')
        // }



    });

    $('body').on("keyup", '.ip_input6', function(e) {
        if ($(this).val().length > 0){
            regexp = /^[0-9a-fA-F]+$/;
            if (!regexp.test($(this).val())) {
                alert('Only Hexadecimal inputs are allowed!');
                $(this).val('');
            }
        }
    });

    $('body').on("keyup", '.ip_input', function(e) {
        if($(this).val()>255){
            alert('The value of IP address should be less than 255');
            $(this).val('');
        }
        e.preventDefault();

    });
</script>
@endsection
